#!/usr/bin/perl -w

use utf8;
use strict;
use warnings;

use Data::Dumper;
use Test::More tests => 2;
use Yandex::Log;

require_ok('Yandex::Catalogia');

my $log = Yandex::Log->new( no_log => 1 );

my @input = (
         '1',
         {
            'error_msg' => undef,
            'headers' => {
                           'URL' => 'http://catalogia-mod.yandex.ru/cgi-bin/get_categs.pl',
                           'connection' => 'close',
                           'Status' => '200',
                           'HTTPVersion' => '1.1',
                           'date' => 'Mon, 07 Jul 2014 12:20:33 GMT',
                           'transfer-encoding' => 'chunked',
                           'content-length' => 56,
                           'Reason' => 'OK',
                           'content-type' => 'text/plain; charset="UTF-8"',
                           'server' => 'Apache/2.2.22 (Ubuntu)'
                         },
            'content' => '	Пряники, вафли, печенье	200007183	0,0
',
            'error_type' => undef,
            'elapsed' => '0.070228099822998',
            'is_success' => 1
          },
          1,
          $log
);

my $valid_output = [
            {
              'cat' => [
                         "Пряники, вафли, печенье"
                       ],
              'relevant_phrases' => [
                                    {
                                      'CRP_OK' => undef,
                                    },
                                    {
                                      'CRP_OK' => undef,
                                    }
                                  ],
              'cat_ids' => [
                             '200007183'
                           ],
              'is_relevant' => undef,
              'is_empty' => '',
              'flag' => []
            }
];

is_deeply( Yandex::Catalogia::__process_response( @input ), $valid_output, '__process_response' );

