package Yandex::Cbb;

# $Id$

=head1 NAME

    Yandex:Cbb

=head1 DESCRIPTION

    Работа с сервисом cbb.yandex.net

=cut

use strict;
use warnings;

use URI::Escape qw/uri_escape/;
use LWP::UserAgent;

use base qw/Exporter/;
our @EXPORT = qw/cbb_add_range cbb_del_range/;

our $CBB_URL = 'http://cbb.yandex.net';
our $TIMEOUT = 10;

=head2 cbb_add_range(flag => 13, ip_from => 'xx.xx.xx.xx', ip_to => 'xx.xx.xx.xx', expire_period => 24*60*60, description => '')

    добавить блокировку для диапазона ip адресов

=cut
sub cbb_add_range {
    my (%props) = @_;

    my $url = "http://cbb.yandex.net/cgi-bin/set_range.pl"
              . "?flag=" . uri_escape($props{flag})
              . "&range_src=" . uri_escape($props{ip_from})
              . "&range_dst=" . uri_escape($props{ip_to})
              . "&description=" . uri_escape($props{description})
              . "&operation=add"
              . "&expire=" . uri_escape(time() + $props{expire_period});

    my $resp = LWP::UserAgent->new(timeout => $TIMEOUT)->get($url);

    if (!$resp->is_success()) {
        die "Can't add cbb range: ".$resp->status_line;
    } elsif ($resp->content() !~ /ok/si) {
        die "Can't add cbb range, response: ".$resp->content();
    }
}

=head2 cbb_del_range(flag => 13, ip_from => 'xx.xx.xx.xx', ip_to => 'xx.xx.xx.xx', description => '')

    удалить блокировку для диапазона ip адресов

=cut
sub cbb_del_range {
    my (%props) = @_;

    my $url = "http://cbb.yandex.net/cgi-bin/set_range.pl"
              . "?flag=" . uri_escape($props{flag})
              . "&range_src=" . uri_escape($props{ip_from})
              . "&range_dst=" . uri_escape($props{ip_to})
              . "&description=" . uri_escape($props{description})
              . "&operation=del";

    my $resp = LWP::UserAgent->new(timeout => $TIMEOUT)->get($url);

    if (!$resp->is_success()) {
        die "Can't del cbb range: ".$resp->status_line;
    } elsif ($resp->content() !~ /ok/si) {
        die "Can't del cbb range, response: ".$resp->content();
    }
}

1;
