package Yandex::UTF8CGI;

# Wrapper for the CGI module, which converts form input to UTF-8.
# Please see http://dysphoria.net/code/perl-utf8/ for documentation.
# Small changes by zhur@yandex-team.ru

use strict;
use CGI::Util ();
use base qw/CGI/;
use Encode;

$CGI::DefaultClass = __PACKAGE__;
our $AutoloadClass = 'CGI';

sub new {
    my ($class, $encoding, @args) = @_;
    binmode \*STDIN;
    my $self = CGI::new( undef, @args );
    $self->{'.ya_encoding'} = $encoding;
    decode_CGI($self);
    return $self;
}


sub parse_params {
    my($self,$tosplit) = @_;

    my $param_hash;
    if ( $CGI::VERSION <= '3.15'){
        $param_hash = $self;
    } else {
        $param_hash = $self->{param} ||= {};
    }

    my(@pairs) = split(/[&;]/,$tosplit);
    my($param,$value);
    foreach (@pairs) {
        ($param,$value) = split('=',$_,2);
        next unless defined $param;
        next if $CGI::NO_UNDEF_PARAMS and not defined $value;
        $value = '' unless defined $value;
        $param = unescape($param);
        $value = unescape($value);
        $self->add_parameter($param);
        push (@{$param_hash->{$param}},$value);
    }
}


# like CGI::Util::unescape
sub unescape {
  shift() if @_ > 0 and (ref($_[0]) || (defined $_[1] && $_[0] eq $CGI::DefaultClass));
  my $todecode = shift;
  return undef unless defined($todecode);
  Encode::_utf8_off( $todecode );
  $todecode =~ tr/+/ /;       # pluses become spaces
  $todecode =~ s/%(?:([0-9a-fA-F]{2})|u([0-9a-fA-F]{4}))/defined($1)? pack 'C', hex($1) : CGI::Util::utf8_chr(hex($2))/ge;
  return $todecode;
}

sub decode_CGI {
    my ($query) = @_;
    
    my $content_type = ($query->content_type() or '');
    my $decoder;
    if ($content_type =~ /charset=([a-zA-Z0-9\-]+)/) {
        $decoder = Encode::find_encoding($1);
    }
    # If all else fails, assume utf8:
    $decoder = Encode::find_encoding('utf8') if !ref $decoder;
    my $encname = $query->{'.ya_encoding'} || $decoder->name;
    
    # old CGI.pm stores parameters on top level of $self, 
    # newer versions use $self->{param}
    my $param_hash;
    if ( $CGI::VERSION <= '3.15'){
        $param_hash = $query;
    } else {
        $param_hash = $query->{param};
    }
    # (Since this is user input, we don’t want to barf if we can help it.)
    foreach my $key ($query->param) {
        # We’ve got to do this conversion in-place, since some of the strings may also
        # be filehandles (to allow file uploads). Wacky, but true.
        if ( ref $param_hash->{$key} eq 'ARRAY' ) {
            foreach my $val ( @{$param_hash->{$key}} ) {
                if ( ref $val ) {
                    # Process Filehandler
                    $val->save_decoded_name(my_decode($val->old_asString, $encname));
                } else {
                    # Process SCALAR
                    $val = my_decode($val, $encname);
                }
            }
        }
    }
}

sub my_decode ($$) {
    my ($name, $encname) = @_;
    if ( !Encode::is_utf8($name) && $encname ne 'utf8' ) {
        Encode::from_to($name, $encname, 'utf8');
    }
    Encode::_utf8_on($name);
    if ( !Encode::is_utf8($name, 1) ) {
        Encode::_utf8_off($name);
        $name = Encode::decode('cp1251', $name);
    }
    return $name;
}

package Fh;
our %decoded_names = ();

our $AUTOLOADED_ROUTINES or die "no AUTOLOADED_ROUTINES defined";
$AUTOLOADED_ROUTINES .= q/
$SUBS{asString} = qq!
sub asString {
    return shift->decoded_name
}
!;
/;

sub decoded_name {
    my $self = shift;
    return $decoded_names{$$self};
}

sub old_asString {
    my $self = shift;
    # get rid of package name
    (my $i = $$self) =~ s/^\*(\w+::fh\d{5})+//;
    $i =~ s/%(..)/ chr(hex($1)) /eg;
    return $i.$CGI::TAINTED;
}

sub save_decoded_name{
    my $self = shift; 
    my $name = shift;
    $decoded_names{$$self} = $name; 
}
1;
