#!/usr/bin/perl -w
use strict;
use warnings;
use Test::More tests => 9;
use Yandex::Clickhouse::Result;

my $result = Yandex::Clickhouse::Result->new;
is($result->{data}, undef);

$result = Yandex::Clickhouse::Result->new('{"test": 42}');
is_deeply($result->json, {"test" => 42});

$result = Yandex::Clickhouse::Result->new("hello\t\t\nworld\t\t\n");
is_deeply($result->tsv, [["hello", "", ""], ["world", "", ""]]);
is_deeply($result->tsv(columns => ['a', 'b', 'c']), [{a => "hello", b => "", c => ""}, {a => "world", b => "", c => ""}]);

$result = Yandex::Clickhouse::Result->new("hello\\tworld\t42\n\\\"another\\tstr\\ing\\\"\t51\n");
is_deeply($result->tsv, [["hello\tworld", "42"], ["\"another\tstring\"", "51"]]);
is_deeply($result->tsv(columns => ['a', 'b']), [{a => "hello\tworld", b => "42"}, {a => "\"another\tstring\"", b => "51"}]);
is_deeply($result->tsv(columns => ['a']), [{a => "hello\tworld"}, {a => "\"another\tstring\""}]);
is_deeply($result->tsv(columns => ['a', 'b', 'c']), [{a => "hello\tworld", b => "42", c => undef}, {a => "\"another\tstring\"", b => "51", c => undef}]);

$result = Yandex::Clickhouse::Result->new("a\tb\nhello\\tworld\t42\n\\\"another\\tstr\\ing\\\"\t51\n");
is_deeply($result->tsv(names => 1), [{a => "hello\tworld", b => "42"}, {a => "\"another\tstring\"", b => "51"}]);

done_testing();
