#!/usr/bin/perl -w
use strict;
use warnings;
use Test::More;
use Time::HiRes qw(sleep);
use Yandex::Clickhouse;
BEGIN {
    plan skip_all => 'Yandex::Profile is not available' unless eval "use Yandex::Profile qw(); 1";
    plan skip_all => 'AnyEvent::HTTPD is not available' unless eval "use AnyEvent::HTTPD; 1";
    plan tests => 6;
    AnyEvent::detect();
}

{
    my $delay = 0.2;
    Yandex::Profile::init();
    ok(!exists(Yandex::Profile::stats->{"Yandex::Clickhouse::query_async#"}), 'Profile stats should be empty');
    my $httpd = AnyEvent::HTTPD->new;
    $httpd->reg_cb(
        '' => sub {
            my ($httpd, $req) = @_;
            sleep $delay;
            $req->respond([200, 'OK', {}, "hello\n"]);
            $httpd->stop_request;
        },
    );
    my $c = Yandex::Clickhouse->new(host => $httpd->host, port => $httpd->port);
    my $result = $c->query("SELECT 'hello'");
    is(ref($result), "Yandex::Clickhouse::Result");
    is($result->{data}, "hello\n");
    ok(exists(Yandex::Profile::stats->{"Yandex::Clickhouse::query_async#"}), 'Profile stats should have an entry');
    my $stats = Yandex::Profile::stats->{"Yandex::Clickhouse::query_async#"};
    ok($stats->{ela} >= $delay, "Query ela should be >= $delay, not $stats->{ela}");
    is($stats->{cnt}, 1, 'Query cnt should be 1');
}
