#!/usr/bin/perl

=head1 NAME

    cocaine-worker.pl

=cut

use 5.010;
use strict;
use warnings;
use utf8;

use lib::abs '../lib';

use Carp;
use Getopt::Long;

use Cocaine;




my $MODULE;


my $getopt_conf = Getopt::Long::Configure(qw/ pass_through /);
GetOptions(
    'help' => sub {exit 0;},
    'module=s' => \$MODULE,
)
or croak "Bad options, stop";

if ($ENV{COCAINE_MODULE}) {
    croak "Use argument --module or enviroment variable COCAINE_MODULE to specify modules, not both"  if $MODULE;
    $MODULE = $ENV{COCAINE_MODULE};
}

croak "Module is not defined"  if !$MODULE;
croak "Incorrect module name"  if $MODULE !~ /^ \w+ (?: ::\w+ )* $/xms;



Getopt::Long::Configure($getopt_conf);
my $cocaine = Cocaine->create_from_args(\@ARGV);
my $cocaine_worker = $cocaine->create_worker_from_args(\@ARGV);

croak "Incorrect params: " . join(q{ }, @ARGV)  if @ARGV;


require ($MODULE =~ s/::/\//gxr).".pm";

my %bind;
my $obj = "$MODULE"->new(cocaine => $cocaine, worker => $cocaine_worker);
for my $method (@{$obj->methods}) {
    croak "Method $method is already defined"  if exists $bind{$method};
    $bind{$method} = sub {
        return $obj->invoke($method, @_);
    };
}


my $result = $cocaine_worker->run(\%bind);
say STDERR "Finished: $result";


exit;



