package Example;

use 5.010;
use strict;
use warnings;

use Mouse;
BEGIN { extends 'Cocaine::App'; }


use Carp;
use Data::MessagePack;
use YAML;
use FindBin qw/$Bin/;



sub u_turn :CocaineMethod {
    my ($self, $param) = @_;

    my $msg = $param->{message} // "do geese see god";
    return { message => scalar reverse $msg };
}

=cocaine-method prices
result:
  type: array
  items:
    type: number
    multipleOf: 0.01
=cut

sub prices
    :CocaineMethod
    :FitToSchema
{
    my ($self, $args) = @_;
    return [7, 8.66666667, "10"];
}


sub explicit_die :CocaineMethod(die) {
    my ($self, $param) = @_;

    my $msg = $param->{message} // "Explicit die";
    die $msg;
}


sub raw_http :CocaineRawMethod {
    my ($self, $param) = @_;

    my $header = [
            200,
            [
                [ "Server", "perl-raw" ],
                [ "Content-Type", "text/plain" ],
            ],
        ];
    my $body = Dump( Data::MessagePack->unpack($param) );

    return $header, $body;
}


sub plack_http :CocaineHttpMethod {
    my ($self, $request) = @_;

    #plack 
    state $app = sub {
        my ($env) = @_;
        return [
            200,
            [
                'Content-Type' => 'text/plain',
                'Server' => 'perl-plack',
                'Header-with-Number' => 123,
            ],
            [$Bin, Dump $env]
        ];
    };

    return $app->($request);
}


__PACKAGE__->declare_psgi_method(psgi => "$Bin/../example/test.psgi");


sub plack_http_error :CocaineHttpMethod {
    my ($self, $request) = @_;

    die "Application died";
}


__PACKAGE__->meta->make_immutable;
1;
