package Cocaine::App::Exception;

use 5.010;
use strict;
use warnings;

use base qw/Exception::Class::Base/;

use Carp;
use Scalar::Util qw/blessed/;

sub Fields {
    return ($_[0]->SUPER::Fields(), 'code', 'interpretation');
}

sub code { $_[0]->{code} }
sub interpretation { $_[0]->{interpretation} }


{
my %error_interpretation = (
    InternalError => 'internal error',
    InvalidRequest => "wrong request format",
    InvalidResponse => "incompatible method response",
    MethodIsUnknown => 'method is unknown',
    MethodIsUnsupported => 'method is unsupported',
);

sub set_error_interpretation
{
    my ($self, $code, $interpretation) = @_;
    # croak if $error_msg{$code};
    $error_interpretation{$code} = "$interpretation";
    return;
}

sub get_formal_error {
    my ($self, $error) = @_;
    $error = $self  if !$error;

    my ($code, $interpretation, $details);
    if ( !blessed $error || !$error->isa('Cocaine::App::Exception') ) {
        $code = 'InternalError';
        $details = "$error";
    }
    else {
        $code = $error->code();
        $interpretation = $error->interpretation();
        $details = $error->message();
    }

    $interpretation ||= $error_interpretation{$code} || $code;

    return { code => $code, message => $interpretation, details => $details };
}

}

1;
