package Yandex::Compress;

# $Id$

=head1 NAME

    Yandex::Compress
    Модуль для сжатия/распаковки данных (обёртка вокруг Compress::Raw::Zlib)

=head1 DESCRIPTION

=cut

use strict;
use warnings;

use Compress::Raw::Zlib qw/Z_OK Z_STREAM_END Z_FINISH/;

use base qw/Exporter/;
our @EXPORT = qw/
    inflate deflate
    mysql_compress mysql_uncompress
/;

my ( $deflator, $inflator );

=head2 deflate($data)

    Сжатие строки байт

=cut

sub deflate{

    my $in = shift;
    my $out;
    my $status;

    return( '' ) if ( ! defined( $in ) || $in eq '' );

    if ( ! $deflator ) {
        ( $deflator, $status ) = new Compress::Raw::Zlib::Deflate ( '-Level' => 9, '-AppendOutput' => 1 );
        die( "Can't create deflate object: ${status}" ) if ( ! $deflator || $status != Z_OK );
    }

    $status = $deflator->deflate( $in, $out );

    if ( $status != Z_OK ) {
        my $msg = $deflator->msg();
        undef( $deflator );
        die( 'Can\'t deflate: ' . $msg );
    }

    $status = $deflator->flush( $out, Z_FINISH );

    if ( $status != Z_OK ) {
        my $msg = $deflator->msg();
        undef( $deflator );
        die( 'Can\'t flush: ' . $msg );
    }

    $status = $deflator->deflateReset();

    if ( $status != Z_OK ) {
        my $msg = $deflator->msg();
        undef( $deflator );
        die( 'Can\'t reset deflator: ' . $msg );
    }

    return( $out );
}

=head2 inflate($compressed_data)

    Распаковка данных

=cut

sub inflate {

    my $in = shift;
    my $out;
    my $status;

    return( '' ) if ( ! defined( $in ) || $in eq '' );

    if ( ! $inflator ) {
        ( $inflator, $status ) = new Compress::Raw::Zlib::Inflate ();
        die( "Can't create inflate object: ${status}" ) if ( ! $inflator || $status != Z_OK );
    }

    $status = $inflator->inflate( $in, $out );

    if ( $status != Z_STREAM_END && $status != Z_OK ) {
        my $msg = $inflator->msg();
        undef( $inflator );
        die( 'Can\'t inflate: ' . $msg );
    }

    $status = $inflator->inflateReset();

    if ( $status != Z_OK ) {
        my $msg = $inflator->msg();
        undef( $inflator );
        die( 'Can\'t reset inflator: ' . $msg );
    }

    return( $out );
}

=head2 mysql_compress($data)

    Полный аналог встроенной функции COMPRESS из mysql

=cut
sub mysql_compress($) {
    my $data = shift;
    return '' if !defined $data || $data eq '';
    my $ret = pack("V", bytes::length($data)).deflate($data);
    if (bytes::substr($ret, -1, 1) eq ' ') {
        $ret .= '.';
    }
    return $ret;
}

=head2 mysql_uncompress($compressed_data)

    Полный аналог встроенной функции UNCOMPRESS из mysql

=cut
sub mysql_uncompress($) {
    my $cdata = shift;
    if (!defined $cdata || $cdata eq '') {
        return '';
    } elsif (bytes::length($cdata) < 4) {
        die "Malformed compressed data";
    } else {
        return inflate(bytes::substr($cdata, 4));
    }
}

1;
__END__
