#!/usr/bin/perl -w

use strict;

use Test::More;

use Fatal qw/open read/;
use Yandex::Compress;

my @sizes = (0, 1, 10, 324, 54653);

Test::More::plan(tests => 4 + 2 * scalar(@sizes));

open(my $urand_fh, "<", "/dev/urandom");

is('', deflate(undef));
is('', deflate(''));
is('', inflate(undef));
is('', inflate(''));

for my $size (@sizes) {
    for my $type (qw/rand space/) {
        my $data = '';
        if ($size) {
            if ($type eq 'rand') {
                read($urand_fh, $data, $size);
            } else {
                $data = ' ' x $size;
            }
        }

        #print length($data), " - ", length(deflate($data)), "\n";
        is($data, inflate(deflate($data)), "type: $type, size: $size");
    }
}
