#!/usr/bin/perl -w

use strict;

use Test::More tests => 22004;

use Yandex::Compress;
use Yandex::DBTools;
use Yandex::DBUnitTest;

is(mysql_compress(undef), '');
is(mysql_compress(''), '');
is(mysql_uncompress(undef), '');
is(mysql_uncompress(''), '');

srand(1);
for my $i (1..10_000) {
    my $str = rand()."afjsdiwenvasdkfja;lkerjqweoinvxcd;vjhprowqenfdasnvashfowiejr;lvnkjdsporiuh".rand();

    my $perl_compressed = mysql_compress($str);
    my $sql_compressed = get_one_field_sql(UT, "SELECT compress(?)", $str);

    my $sql_uncompressed = get_one_field_sql(UT, "SELECT uncompress(?)", $perl_compressed);
    my $perl_uncompressed = mysql_uncompress($sql_compressed);

    is($str, $sql_uncompressed);
    is($str, $perl_uncompressed);
}

srand(2);
for my $i (1..1000) {
    my $str = join '', map {rand()} (1..1000);

    my $perl_compressed = mysql_compress($str);
    my $sql_compressed = get_one_field_sql(UT, "SELECT compress(?)", $str);

    my $sql_uncompressed = get_one_field_sql(UT, "SELECT uncompress(?)", $perl_compressed);
    my $perl_uncompressed = mysql_uncompress($sql_compressed);

    is($str, $sql_uncompressed);
    is($str, $perl_uncompressed);
}
