#!/usr/bin/env perl

# $ host2fw catalogia-media-dev01e
# catalogia-media-dev01e.yandex.ru
#   bm : _C_BM_
#   bm_dev : _C_BM_DEV_
#   bm_dev_catalogia : not exported to fw
# * bm_dev_catalogia_media : _C_BM_DEV_CATALOGIA_MEDIA_

use strict;
use warnings;

die "Usage: $0 hostname\n" if not scalar @ARGV;

my @ip_list = map { /(\S+)$/ && $1 } grep { /\baddress\b/ } split /\n/, qx(host $ARGV[0]);
my %fqdn_hash = map { $_ = (grep { /\bpointer\b/ } split /\n/, qx(host $_))[0]; /(\S+)\.$/ && ($1, undef) } @ip_list;

for my $fqdn (keys %fqdn_hash) {
    my $c_group_main = (grep { /:group:/ } split /\n/, qx(curl -s "https://c.yandex-team.ru/api/hosts/$fqdn?format=yaml"))[0];
    $c_group_main =~ s/^.*\s+//;
    my %c_groups = map { $_ => "not exported to fw" } split /\n/, qx(curl -s "https://c.yandex-team.ru/api/hosts2groups/$fqdn");
    for my $cgr (keys %c_groups) {
        my $exported = grep { /export_to_racktables: true/ } split /\n/, qx(curl -s "https://c.yandex-team.ru/api/groups/$cgr?format=yaml");
        my $macro = $cgr;
        $macro =~ s/-/_/g;
        $macro = "_C_" . uc($macro) . "_";
        $c_groups{$cgr} = "$macro" if $exported;
    }

    print "$fqdn\n";
    map { print(($_ eq $c_group_main ? "* " : "  ") . "$_ : $c_groups{$_}\n") } sort keys %c_groups;
}
