#!/usr/bin/perl
use strict;
use warnings;

use Test::Deep;
use Test::Exception;
use Test::HTTP::Server;
use Test::More tests => 2;

use Yandex::Conductor;

my $server = Test::HTTP::Server->new();
$Yandex::Conductor::CONDUCTOR_API_URL = $server->uri . 'api';

is_deeply( conductor_get_host_tags('existing_host'), [ qw( tag1 tag2 tag3 ) ], 'existing_host' );
dies_ok { conductor_get_host_tags('bogus_host') } 'bogus_host';

sub Test::HTTP::Server::Request::api {
    my ( $self, $method, $host ) = @_;

    unless ( $method eq 'get_host_tags' ) {
        $self->{out_code} = '404 Not Found';
        return '';
    }

    if ( $host eq 'existing_host' ) {
        return join( "\n", qw( tag1 tag2 tag3 ) );
    }

    $self->{out_code} = '404 Not Found';
    return "Host not found";
}
