#!/usr/bin/perl
use strict;
use warnings;

use Test::Deep;
use Test::Exception;
use Test::HTTP::Server;
use Test::More tests => 2;

use Yandex::Conductor;

my $server = Test::HTTP::Server->new();
$Yandex::Conductor::CONDUCTOR_API_URL = $server->uri . 'api';

is_deeply( conductor_groups2hosts('existing_group'), [ qw( host1 host2 host3 ) ], 'existing_group' );
dies_ok { conductor_groups2hosts('bogus_group') } 'bogus_group';

sub Test::HTTP::Server::Request::api {
    my ( $self, $method, $groups ) = @_;

    unless ( $method eq 'groups2hosts' ) {
        $self->{out_code} = '404 Not Found';
        return '';
    }

    if ( $groups eq 'existing_group' ) {
        return join( "\n", qw( host1 host2 host3 ) );
    }

    $self->{out_code} = '404 Not Found';
    return "No groups found";
}
