#!/usr/bin/perl
use strict;
use warnings;

use Test::Deep;
use Test::Exception;
use Test::HTTP::Server;
use Test::More tests => 2;

use Yandex::Conductor;

my $server = Test::HTTP::Server->new();
$Yandex::Conductor::CONDUCTOR_API_URL = $server->uri . 'api';

my $hostinfo = [ {
    'root_datacenter' => 'ugr',
    'fqdn' => 'existing_host.yandex.ru',
    'admins' => [ 'rivik', ],
    'group' => 'existing_group',
    'short_name' => 'existing_host',
    'description' => "",
    'datacenter' => 'ugr6'
} ];

is_deeply( conductor_hosts('existing_host'), $hostinfo, 'existing_host' );
dies_ok { conductor_hosts('bogus_host') } 'bogus_host';

sub Test::HTTP::Server::Request::api {
    my ( $self, $method, $query ) = @_;
    my ($host, $format) = ($query =~ /(\w+)\?format=(\w+)/);

    unless ( $method eq 'hosts' ) {
        $self->{out_code} = '404 Not Found';
        return '';
    }

    if ( $host eq 'existing_host' && $format eq 'json' ) {
        return q([{"group":"existing_group","fqdn":"existing_host.yandex.ru","datacenter":"ugr6","root_datacenter":"ugr","short_name":"existing_host","description":"","admins":["rivik"]}]);
    }

    $self->{out_code} = '404 Not Found';
    return "Host not found";
}
