#!/usr/bin/perl

use Direct::Modern;

use Test::HTTP::Server;
use JSON;

use Yandex::CRM;


use Test::More tests => 4;


our $fake_files_list = {
    "items" => [
        {
            'fileSize' => 1,
            'name' => 'file1',
            'id' => 111
        },
        {
            'fileSize' => 2,
            'name' => 'file2',
            'id' => 222
        }
    ]
};


our $fake_downloaded_file = "file_content";


sub _fake_files_work_result {

    my $param = pop @_;
    my ($test_server) = @_;
    my $url = (split /\?/, $param)[0];

    if ($url eq 'list') {
        $test_server->{'out_headers'} = {'content-type' => 'application/json'};
        return JSON::to_json($fake_files_list);
    }
    elsif ($url eq 'download') {
        return $fake_downloaded_file;
    }

    return;

}


sub _fake_files_work_errors {

    my ($test_server, @params) = @_;
    my $param = pop @params;
    my $url = (split /\?/, $param)[0];

    if ($url eq 'list') {
        $test_server->{'out_headers'}->{'content_type'} = 'application/json';
        return JSON::to_json({'code' => 'TICKET ERROR', 'message' => 'some msg'});
    }
    
    if ($url eq 'download') {
        $test_server->{'out_headers'}->{'content_type'} = 'application/json';
        return JSON::to_json({'code' => 'NO FILE FOUND', 'message' => 'some msg'});
    }

    return;

}


=head2 test_crm

    Тест, проверяющий две ручки crm: 
        получение списка файлов по номеру тикета,
        получение содержимого файла по id файла.

=cut

sub test_crm {

    {
        no strict "refs";
        *Test::HTTP::Server::Request::file = \&_fake_files_work_result;
    }

    my $test_server = Test::HTTP::Server->new();

    $Yandex::CRM::CRM_URL = $test_server->uri;

    my $response = Yandex::CRM::get_files_list(111);
    delete $response->{'headers'};
    is_deeply(
        $response,
        {
            files_list => $fake_files_list->{'items'},
            error_code => undef,
            error_text => undef
        },
        "Files list returned was expected"
    );

    $response = Yandex::CRM::download_file(111);
    delete $response->{'headers'};
    is_deeply(
        $response,
        {
           'content_ref' => \$fake_downloaded_file,
            error_code => undef,
            error_text => undef
        },
        "File content reference returned was expected"
    );

}


sub test_crm_errors {

    {
        no strict "refs";
        *Test::HTTP::Server::Request::file = \&_fake_files_work_errors;
    }

    my $test_server = Test::HTTP::Server->new();
    $Yandex::CRM::CRM_URL = $test_server->uri;

    my $response = Yandex::CRM::get_files_list(111);
    delete $response->{'headers'};
    is_deeply(
        $response,
        {
            files_list => undef,
            error_code => 'TICKET ERROR',
            error_text => 'some msg'
        },
        "Error was not occured but it had to raise a ticket error"
    );

    $response = Yandex::CRM::download_file(111);
    delete $response->{'headers'};
    is_deeply(
        $response,
        {
            content_ref => undef,
            error_code => 'NO FILE FOUND',
            error_text => 'some msg'
        },
        "Error was not occured but it had to raise a file error"
    );

}

test_crm();
test_crm_errors();

