package Yandex::CSV;

=head1 NAME

    Yandex::CSV
    Functions to convert 2d arrays to CSV-files

=head1 SYNOPSIS
    
    csv_quote($)   CSV like escape single value

    csv_unquote($)  make scalar from CSV escaped value

    data2csv($)     convert 2d array to CSV formated scalar

=cut

use Direct::Modern;

use Yandex::CSVWriter;
use Yandex::ScalarUtils;
use base qw/Exporter/;
our @EXPORT = qw/
csv_quote csv_unquote data2csv
/;

=head2 csv_quote

    CSV like escape single value

    csv_quote('"  123  ') => '""  123  ';

=cut

sub csv_quote($) {
    my $str = str(shift);

    if ($str =~ m/^\s|\s$|[\,\;\\\n\"]/) { #need quote
        $str =~ s/\"/""/g;
        return '"'.$str.'"';
    } else {
        return $str;
    }
}

=head2 csv_unquote

    make scalar from CSV escaped value

    csv_unquote('""  123  ') => '"  123  ';

=cut

sub csv_unquote($) {
    my $csv_str = $_[0];

    if(  $csv_str =~ m/^\".*\"$/s ) {
        $csv_str = substr($csv_str, 1, -1);
        $csv_str =~ s/\"\"/\"/g;
        return $csv_str;
    } else {
        return $csv_str;
    }
}

=head2 data2csv

    convert 2d array to CSV formated scalar

    my $csv_data = data2csv( $data, { option => value ... } );

    $data is either array ref or generator coderef

    Available options:
        binmode
        bom_header
        output_file
        header_row
        and all other Text::CSV options

=cut

sub data2csv($;$) {
    my ( $data, $options ) = @_;

    my $result = q{};
    my $w = new Yandex::CSVWriter(delete($options->{output_file}) || \$result, %$options);
    $w->add_data($data);
    $w->close();

    return $result;
}

#sub csv2data(@) {
#}

1;

