#!/usr/bin/perl -w

use strict;
use Test::More tests => 12;

use Yandex::CSV;

is(csv_quote("test"), "test", "test");
is(csv_quote("  test"), "\"  test\"", "\"  test\"");
is(csv_quote("test  "), "\"test  \"", "\"test  \"");
is(csv_quote("test\ntest"), "\"test\ntest\"", "\"test\\ntest\"");
is(csv_quote("test    test"), "test    test", "test    test");
is(csv_quote("test\""), "\"test\"\"\"", "\"test\"\"\"");


is(csv_unquote("test"), "test", "test");
is(csv_unquote("\"  test\""), "  test", "\"  test\"");
is(csv_unquote("\"test  \""), "test  ", "\"test  \"");
is(csv_unquote("\"test\ntest\""), "test\ntest", "\"test\\ntest\"");
is(csv_unquote("\"test    test\""), "test    test", "test    test");
is(csv_unquote("\"test\"\"\""), "test\"", "\"test\"\"\"");


