#!/usr/bin/perl -w

use strict;
use utf8;
use Encode;

use Test::More;

use Yandex::CSV;


is( data2csv( [["test","  test","test  ","test\ntest","test    test","test\""]] ),
    "test,\"  test\",\"test  \",\"test\ntest\",\"test    test\",\"test\"\"\"\r\n",
    "quoting_test");

is( data2csv( [[1,2,3],[4,5,6]] ), "1,2,3\r\n4,5,6\r\n", "multiple lines");

is( data2csv( [[1,2,3],[4,5,6]], { eol => '--' } ), "1,2,3--4,5,6--", "custom record separator");

is( data2csv( [[1,2,3],[4,5,6]], { sep_char => '-' } ), "1-2-3\r\n4-5-6\r\n", "custom field separator");

is( data2csv( [[1,2,3],[4,5,6]], { bom_header => 1 } ), "\x{feff}1,2,3\r\n4,5,6\r\n", "BOM");

is( data2csv( [[4,5,6]], { header_row => [ qw{ a b c} ] } ), "a,b,c\r\n4,5,6\r\n", "header row");

is( data2csv( [[1,2,3],[4,5,"\x{1234}"]], { binmode => ':utf8' } ), encode( 'utf8',"1,2,3\r\n4,5,\"\x{1234}\"\r\n" ), "binmode :utf8");

is( data2csv( [{a=>4,b=>5,c=>6}], { header_row => [ qw{a b c} ] } ), "a,b,c\r\n4,5,6\r\n", "hash rows");

{
    my @data = ( [1,2,3], [4,5,6] );
    sub gen_rec {
        my $row = shift @data;
        return $row ? @$row : ();
    }
}

is( data2csv( \&gen_rec ), "1,2,3\r\n4,5,6\r\n", "record generator");


done_testing();
