package Yandex::ScalarUtils;

=head1 NAME

    Yandex::ScalarUtils
    Сборник функций для работы со скалярами.

=head1 SYNOPSIS

    str undef # => ''
    str 'qweqweqw' # => 'qweqweqw'

=cut

use strict;
use warnings;

use base qw/Exporter/;
our @EXPORT = our @EXPORT_OK = qw/str/;

=head2 str

    str - сделать из переменной валидную строчку
    при вызове без аргумента возвращает валидную строчку от $_
    функция призвана минимизировать количество использований паттерна defined $some_variable ? $some_variable : ''

=cut

sub str(;$){
    my $x = scalar @_ ? $_[0] : $_;
    return defined $x ? "$x" : ""; 
}

1;

