#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More tests => 27;
use Test::Deep;

BEGIN { use_ok( 'Yandex::HashUtils' ); }

use utf8;
use open ':std' => ':utf8';

$|++;

cmp_deeply(hash_copy({}, {1=>1, 2=>2}), {});
cmp_deeply(hash_copy({}, {1=>1, 2=>2}, []), {});

cmp_deeply(hash_copy({}, {1=>1, 2=>2}, 1), {1=>1});
cmp_deeply(hash_copy({}, {1=>1, 2=>2}, [1]), {1=>1});

cmp_deeply(hash_copy({5=>5}, {1=>1, 2=>2}, 1, 2), {1=>1, 2=>2, 5=>5});
cmp_deeply(hash_copy({5=>5}, {1=>1, 2=>2}, [1, 2]), {1=>1, 2=>2, 5=>5});

cmp_deeply(hash_copy({}, {1=>1, 2=>2}, 2), {2=>2});
cmp_deeply(hash_copy({}, {1=>1, 2=>2}, [2]), {2=>2});

cmp_deeply(hash_copy({}, {1=>1, 2=>2}, 3), {});

cmp_deeply(hash_copy(undef, {1=>1, 2=>2}, 1), {1=>1});

cmp_deeply(hash_copy(undef, {1=>1, 2=>2}, 3), {});

cmp_deeply(hash_copy({5=>5}, undef, 3), {5 => 5});

my $dst = {5 => 5};
cmp_deeply(hash_copy($dst, {1=>1, 2=>2}, 1), {5 => 5, 1=>1});

cmp_deeply($dst, {5 => 5, 1=>1});


sub long_hash_copy($$@) {
    my ($dst, $src, @keys) = @_;
    return hash_merge $dst, hash_cut $src, @keys;
}

# Check that hash_copy does the same as its longer variant 
for my $args (
    [{}, {1=>1, 2=>2}, ],
    [{}, {1=>1, 2=>2}, 1],
    [{}, {1=>1, 2=>2}, 1,2],
    [{}, {1=>1, 2=>2}, ],
    [{}, {1=>1, 2=>2}, [1]],
    [{}, {1=>1, 2=>2}, [1,2]],
    
    [{1=>11, 2=>22}, {1=>1, 2=>2}, ],
    [{1=>11, 2=>22}, {1=>1, 2=>2}, 1],
    [{1=>11, 2=>22}, {1=>1, 2=>2}, 1,2],

    [{1=>0,2=>1}, {1=>1, 2=>2}, 1,2],
    [{1=>[]}, {1=>{}, 2=>2}, 2,1],
    [{1=>undef, 2=>[]}, {1=>{}, 2=>undef}, 2,1],
        ) {
    my ($dst1, $src1, @keys1) = @$args;
    my ($dst2, $src2, @keys2) = @$args;

    cmp_deeply(hash_copy($dst1, $src1, @keys1), long_hash_copy($dst2, $src2, @keys2));    
}



