#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More;
use Test::Deep;
use Test::Exception;

BEGIN { use_ok( 'Yandex::HashUtils' ); }

use utf8;
use open ':std' => ':utf8';

# not a hash ref
my %tmp_hash = (
    1  => 1,
    10 => 'value',
);

dies_ok ( sub { hash_cut(%tmp_hash   ) }, 'First argument must be a reference to hash');
dies_ok ( sub { hash_cut(%tmp_hash, 1) }, 'First argument must be a reference to hash');

SKIP: { # При получении первым аргументом НЕ ссылки на хеш - желательно, чтобы функция 'падала'
    skip 'First argument checking is not yet implemented', 4 if 1;

    dies_ok ( sub { hash_cut(     ) }, 'First argument must be a reference to hash');
    dies_ok ( sub { hash_cut(undef) }, 'First argument must be a reference to hash');
    dies_ok ( sub { hash_cut([]   ) }, 'First argument must be a reference to hash');
    dies_ok ( sub { hash_cut(1    ) }, 'First argument must be a reference to hash');
}

# good hash
# bad keys
cmp_deeply(hash_cut({}                 ), {});
cmp_deeply(hash_cut({},           undef), {});
cmp_deeply(hash_cut({},           []   ), {});
cmp_deeply(hash_cut({1=>1, 2=>2}       ), {});
cmp_deeply(hash_cut({1=>1, 2=>2}, undef), {});
cmp_deeply(hash_cut({1=>1, 2=>2}, []   ), {});

# good keys, but not presented in hash
cmp_deeply(hash_cut({1=>1, 2=>2}, 3        ), {});
cmp_deeply(hash_cut({1=>1, 2=>2}, [3]      ), {});
cmp_deeply(hash_cut({1=>1, 2=>2}, 3,      4), {});
cmp_deeply(hash_cut({1=>1, 2=>2}, [3, 4]   ), {});

# good & bad keys, not presented in hash
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, 3,             undef, 4), {});
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, [3, undef, 4]          ), {});

# good keys, presented in hash
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, 5         ), {5=>5});
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, [5]       ), {5=>5});
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, 5,       1), {1=>1, 5=>5});
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, [5, 1]    ), {1=>1, 5=>5});
cmp_deeply(hash_cut(\%tmp_hash,         1         ), {1=>1});
cmp_deeply(hash_cut(\%tmp_hash,         [10]      ), {10=>'value'});

# good keys, presented (or not) in hash
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, 5,       3), {5=>5});
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, [5, 3]    ), {5=>5});

# good & bad keys, presented (or not) in hash
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, undef,       2), {2=>2});
cmp_deeply(hash_cut({1=>1, 2=>2, 5=>5}, [undef, 2]    ), {2=>2});

done_testing();