#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More tests => 18;
use Test::Deep;
use Test::Exception;

BEGIN { use_ok( 'Yandex::HashUtils' ); }

use utf8;
use open ':std' => ':utf8';

my (%tmp_hash1, %tmp_hash2);

#  not a hash ref
dies_ok ( sub { hash_diff( %tmp_hash1, {}         ) }, 'First argument must be a reference to hash');
dies_ok ( sub { hash_diff( {},         %tmp_hash1 ) }, 'Second argument must be a reference to hash');

cmp_deeply( hash_diff({a=>1, b=>2}, {b=>2, c=>3}), {a=>undef, c=>3} );
cmp_deeply( hash_diff({a=>1, b=>0}, {b=>2, c=>3}), {a=>undef, b=>2, c=>3}, 'function returns different value from second hash' );
cmp_deeply( hash_diff({a=>1, b=>2}, {b=>0, c=>3}), {a=>undef, b=>0, c=>3}, 'function returns different value from second hash' );

%tmp_hash1 = ( a => 1, b => 2, );
%tmp_hash2 = ( b => 2, c => 3, );

cmp_deeply( hash_diff(\%tmp_hash1, \%tmp_hash2), {a=>undef, c=>3} );
cmp_deeply( \%tmp_hash1,                         {a=>1, b=>2}, 'function should not modify orgignal hash');
cmp_deeply( \%tmp_hash2,                         {c=>3, b=>2}, 'function should not modify orgignal hash');

SKIP: { # Функция пока игнорирует undef значения во втором хеше и не учитывает вложенные объекты
    skip 'Deep comparing hashes is not yet implemented', 5 if 1;

    cmp_deeply( hash_diff({c=>3},                     {a=>undef, b=>undef, c=>3}), {a=>undef, b=>undef});
    cmp_deeply( hash_diff({a=>undef, b=>undef},       {a=>undef, b=>undef}      ), {});
    cmp_deeply( hash_diff({a=>undef, b=>2},           {a=>undef, b=>2}          ), {});
    cmp_deeply( hash_diff({a=>undef, b=>2},           {a=>undef, b=>0}          ), {b=>0});
    cmp_deeply( hash_diff({a=>1, b=>2},               {a=>[0,1], b=>2}          ), {a=>[0,1]});
}

cmp_deeply( hash_diff({a=>undef, b=>undef, c=>3}, {c=>3}),         {a=>undef, b=>undef} ); # undef в первом хеше отрабатывает нормально
cmp_deeply( hash_diff({a=>[0,1], b=>2},           {a=>[0,1], b=>2}                      ), {});
cmp_deeply( hash_diff({a=>{}, b=>2},              {a=>{}, b=>2}                         ), {});
cmp_deeply( hash_diff({a=>[0,1], b=>2},           {a=>1, b=>2}                          ), {a=>1});