#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More;
use Test::Deep;
use Test::Exception;

BEGIN { use_ok( 'Yandex::HashUtils' ); }

use utf8;
use open ':std'=>':utf8';

my $has_digit = sub {
    return m/\d/;
};

my %tmp_hash = (
    a    => 'value2',
    b    => 1,
    str1 => 'string'
);

# not a hash ref
dies_ok ( sub { hash_grep { m/^\d+$/ } %tmp_hash }, 'Second argument must be a reference to hash');
dies_ok ( sub { hash_grep { m/^\d+$/ } 1         }, 'Second argument must be a reference to hash');
dies_ok ( sub { hash_grep { m/^\d+$/ } []        }, 'Second argument must be a reference to hash');

# Применение & в &hash_grep призвано устранить ошибку компиляции Type of arg 1 to Yandex::HashUtils::hash_grep must be block or sub {} (not private variable)
dies_ok ( sub { &hash_grep( $has_digit, %tmp_hash) }, 'Second argument must be a reference to hash');

SKIP: { # При undef вместо ссылки на хеш - желательно, чтобы функция 'падала'
    skip 'Second argument checking is not yet implemented', 1 if 1;

    dies_ok ( sub { hash_grep { m/^\d+$/ } undef }, 'Second argument must be a reference to hash');
}

# normal usage
cmp_deeply( (hash_grep { m/^\d+$/ }  {ab=>'cd', 12=>34, test=>'value'}), {12=>34} );
cmp_deeply( (hash_grep { m/^\d+$/ }  \%tmp_hash),                        {b=>1} );
cmp_deeply( (&hash_grep( $has_digit, \%tmp_hash)),                       {a=>'value2', b=>1} );
cmp_deeply( (&hash_grep( $has_digit, {ab=>'cd', 12=>'c3d', zz=>'val'})), {12=>'c3d'} );
cmp_deeply( (hash_grep { !m/bad/ }   \%tmp_hash),                        \%tmp_hash );
cmp_deeply( (hash_grep { m/bad/ }    undef),                             {},                                  'function should return new empty hash');
cmp_deeply( (hash_grep { m/bad/ }    \%tmp_hash),                        {},                                  'function should return new empty hash');
cmp_deeply( \%tmp_hash,                                                  {b=>1, a=>'value2', str1=>'string'}, 'function should not modify orgignal hash');

done_testing();