#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More;
use Test::Deep;
use Test::Exception;

BEGIN { use_ok( 'Yandex::HashUtils' ); }

use utf8;
use open ':std'=>':utf8';

my $has_digit = sub ($) {
    return m/\d/;
};

my %tmp_hash = (
    a    => 'value',
    b    => 1,
    str1 => 'string',
);

# not a hash ref
dies_ok ( sub { hash_kgrep { m/^\d+$/ } %tmp_hash }, 'Second argument must be a reference to hash');
dies_ok ( sub { hash_kgrep { m/^\d+$/ } 1         }, 'Second argument must be a reference to hash');
dies_ok ( sub { hash_kgrep { m/^\d+$/ } []        }, 'Second argument must be a reference to hash');

# Применение & в &hash_kgrep призвано устранить ошибку компиляции Type of arg 1 to Yandex::HashUtils::hash_kgrep must be block or sub {} (not private variable)
dies_ok ( sub { &hash_kgrep( $has_digit,  %tmp_hash) }, 'Second argument must be a reference to hash');
#####################################################################################################

SKIP: { # При undef вместо ссылки на хеш - желательно, чтобы функция 'падала'
    skip 'Second argument checking is not yet implemented', 1 if 1;

    dies_ok ( sub { hash_kgrep { m/^\d+$/ } undef }, 'Second argument must be a reference to hash');
}

# normal usage
cmp_deeply( (hash_kgrep { m/^\d+$/ }   {ab=>'cd', 12=>34, test=>'value'}), {12=>34} );
cmp_deeply( (hash_kgrep { m/^\d+$/ }   \%tmp_hash),                        {} );
cmp_deeply( (&hash_kgrep( $has_digit,  \%tmp_hash)),                       {str1=>'string'} );
cmp_deeply( (&hash_kgrep( $has_digit,  {ab=>'cd', a1=>2, test=>'value'})), {a1=>2} );
cmp_deeply( (hash_kgrep { m/\w/ }      \%tmp_hash),                        \%tmp_hash );
cmp_deeply( (hash_kgrep { m/\w{5}/ }   undef),                             {},                                 'function should return new empty hash');
cmp_deeply( (hash_kgrep { m/\w{5}/ }   \%tmp_hash),                        {},                                 'function should return new empty hash');
cmp_deeply( \%tmp_hash,                                                    {b=>1, a=>'value', str1=>'string'}, 'function should not modify orgignal hash' );

done_testing();