#!/usr/bin/perl

# $Id$

use warnings;
use strict;

use Test::More;
use Test::Deep;

BEGIN { use_ok( 'Yandex::HashUtils' ); }

use utf8;

my %test = (
    string  => 'str',
    key     => 'value',
    1       => 4,
    2       => 5,
    3       => 6,
);

cmp_deeply(
    hash_kv_map(sub { return $_[1] }, \%test),
    \%test,
    'replace value to itself',
);

cmp_deeply(
    hash_kv_map(sub { return $_[0] }, \%test),
    {
        string => 'string',
        key    => 'key',
        1      => 1,
        2      => 2,
        3      => 3,
    },
    'replace values to keys',
);

cmp_deeply(
    (hash_kv_map { my ($k, $v) = @_; return $v =~ /^\d+$/ && $k =~ /^\d+$/ && $k % 2 ? 2*$v : $v } \%test),
    {
        string => 'str',
        key    => 'value',
        1      => 8,
        2      => 5,
        3      => 12,
    },
    'double numbers for odd keys, skip strings',
);

done_testing();
