#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More;
use Test::Deep;
use Test::Exception;

BEGIN { use_ok( 'Yandex::HashUtils' ); }

use utf8;
use open ':std'=>':utf8';

my $sub_ref1 = sub ($) {
    my $arg = shift;
    $arg =~ tr/a-z/A-Z/;
    return $arg;
};

my %tmp_hash = (
    10   => 'value',
    1    => 1,
    test => 'string',
);

# not a hash ref
dies_ok ( sub { hash_map { m/^(\d+)$/ ? $1 * 2 : $_; } %tmp_hash }, 'Second argument must be a reference to hash');
dies_ok ( sub { hash_map { m/^(\d+)$/ ? $1 * 2 : $_; } []        }, 'Second argument must be a reference to hash');
dies_ok ( sub { hash_map { m/^(\d+)$/ ? $1 * 2 : $_; } 1         }, 'Second argument must be a reference to hash');

# Применение & в &hash_map призвано устранить ошибку компиляции Type of arg 1 to Yandex::HashUtils::hash_kmap must be block or sub {} (not private variable)
dies_ok ( sub { &hash_map( $sub_ref1, %tmp_hash) }, 'Second argument must be a reference to hash');

SKIP: { # При undef вместо ссылки на хеш - желательно, чтобы функция 'падала', а не возвращала пустой хеш
    skip 'Second argument checking is not yet implemented', 1 if 1;

    dies_ok ( sub { hash_map { m/^(\d+)$/ ? $1 * 2 : $_; } undef }, 'Second argument must be a reference to hash');
}

# # normal usage
cmp_deeply( (hash_map { s/([a-e])/\U$1/g; return $_; } {ab=>'cd', 12=>34, test=>'value', z=>7}), {ab=>'CD', 12=>34, test=>'vAluE', z=>7  } );
cmp_deeply( (hash_map { m/^(\d+)$/ ? $1 * 2 : $_; }    {ab=>'cd', 12=>34, test=>'value', z=>7}), {ab=>'cd', 12=>68, test=>'value', z=>14 } );
cmp_deeply( (hash_map { m/^(\d+)$/ ? $1 * 2 : $_; }    {ab=>'cd', test=>'value', z=>7        }), {ab=>'cd', test=>'value', z=>14         } );
cmp_deeply( (hash_map { m/^(\d+)$/ ? $1 * 2 : $_; }    \%tmp_hash                             ), {1=>2, 10=>'value', test=>'string'      } );
cmp_deeply( (&hash_map( $sub_ref1,                     \%tmp_hash                            )), {1=>1, 10=>'VALUE', test=>'STRING'      } );
cmp_deeply( \%tmp_hash                                                                         , {1=>1, 10=>'value', test=>'string'},       'function should not modify orgignal hash' );

done_testing();