#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More;
use Test::Deep;
use Test::Exception;

BEGIN { use_ok( 'Yandex::HashUtils' ); }

use utf8;
use open ':std' => ':utf8';

# not a hash ref
my %tmp_hash = (
    1  => 1,
    10 => 'value',
);

dies_ok  ( sub { hash_merge(%tmp_hash,    {1=>1}   ) }, 'First argument must be a reference to hash') ;
dies_ok  ( sub { hash_merge(1,            {1=>1}   ) }, 'First argument must be a reference to hash') ;
dies_ok  ( sub { hash_merge([],           {1=>1}   ) }, 'First argument must be a reference to hash') ;
lives_ok ( sub { hash_merge({1=>1, 2=>2}, %tmp_hash) }, 'Function ignores other arguments which are not references') ;
lives_ok ( sub { hash_merge({1=>1, 2=>2}, 1        ) }, 'Function ignores other arguments which are not references') ;
lives_ok ( sub { hash_merge({1=>1, 2=>2}, []       ) }, 'Function ignores other arguments which are not references') ;
lives_ok ( sub { hash_merge({1=>1, 2=>2}, undef    ) }, 'Function ignores other arguments which are not references') ;

SKIP: { # При первом аргументе undef вместо ссылки на хеш - желательно, чтобы функция 'падала', а не возвращала пустой хеш
    skip 'First argument checking is not yet implemented', 1 if 1;

    dies_ok ( sub { hash_merge(undef, {1=>1}) }, 'First argument must be a reference to hash') ;
}

# Странное поведение функции, обрабатывает первый аргумент undef как {}
cmp_deeply(hash_merge(undef,        {1=>1, 2=>2}, {4=>4, 5=>5}), {1=>1, 2=>2, 4=>4, 5=>5});

cmp_deeply(hash_merge({1=>1, 2=>2}, {4=>4, 5=>5}              ), {1=>1, 2=>2, 4=>4, 5=>5});
cmp_deeply(hash_merge({},           {1=>1, 2=>2}, {4=>4, 5=>5}), {1=>1, 2=>2, 4=>4, 5=>5});
cmp_deeply(hash_merge({},           \%tmp_hash,   {4=>4, 5=>5}), {1=>1, 4=>4, 5=>5, 10=>'value'});

my $hash12_c1 = {1=>1, 2=>2};
cmp_deeply(hash_merge($hash12_c1, {4=>4, 5=>5}), {1=>1, 2=>2, 4=>4, 5=>5}); # returned merged hash
cmp_deeply($hash12_c1,                           {1=>1, 2=>2, 4=>4, 5=>5}); # and first hash has been changed
cmp_deeply(hash_merge(\%tmp_hash, {4=>4, 5=>5}), {1=>1, 4=>4, 5=>5, 10=>'value'});
cmp_deeply(\%tmp_hash,                           {1=>1, 4=>4, 5=>5, 10=>'value'});

# returned merged hash
my $hash12_c2 = {1=>1, 2=>2};
my $hash45_c1 = {4=>4, 5=>5};
cmp_deeply(hash_merge({},    $hash12_c2, $hash45_c1            ), {1=>1, 2=>2, 4=>4, 5=>5});
cmp_deeply(hash_merge(undef, $hash12_c2, $hash45_c1            ), {1=>1, 2=>2, 4=>4, 5=>5});
cmp_deeply(hash_merge(undef, $hash12_c2, {},         $hash45_c1), {1=>1, 2=>2, 4=>4, 5=>5});
cmp_deeply(hash_merge(undef, $hash12_c2, undef,      $hash45_c1), {1=>1, 2=>2, 4=>4, 5=>5});
# and doesn't changed source hashes
cmp_deeply($hash12_c2, {1=>1, 2=>2});
cmp_deeply($hash45_c1, {4=>4, 5=>5});

# check for "if h1 is blessed it left blessed"
bless($hash12_c2, "SPECIAL_HASH");
like(ref hash_merge($hash12_c2, $hash45_c1), qr/SPECIAL_HASH/, 'returned ref should be blessed');
like(ref $hash12_c2, qr/SPECIAL_HASH/, 'original ref should be left blessed');

done_testing();