#!/usr/bin/perl -w

use strict;
use Test::More tests => 8;
use Test::Deep;
use Test::Exception;

use Yandex::ListUtils qw/chunks/;

dies_ok {chunks([], undef)};
dies_ok {chunks([], -4)};
dies_ok {chunks([], 0)};
dies_ok {chunks([], 2.5)};

cmp_deeply([], [chunks([], 1)]);
cmp_deeply([[1], [2], [3]], [chunks([1,2,3], 1)]);
cmp_deeply([[1, 2], [3]], [chunks([1,2,3], 2)]);
cmp_deeply([[1, 2, 3]], [chunks([1,2,3], 8)]);
