#!/usr/bin/perl -w

use strict;
use Test::More;
use Test::Deep;

use Yandex::ListUtils qw/enumerate_iter/;

use Carp ();
$SIG{__WARN__} = \&Carp::cluck;

sub e1 {
    my @ret;
    my $it = enumerate_iter @_;
    while(my @a = $it->()) {
        push @ret, \@a;
    }
    return \@ret;
}

sub e2 {
    my @ret;
    for(my $it = enumerate_iter @_; my @q = $it->(); ) {
        push @ret, \@q;
    }
    return \@ret;
}

cmp_deeply(e1([1,2,3]), [[0,1], [1,2], [2,3]]);
cmp_deeply(e1([1,2,3], [4,2]), [[0,1,4], [1,2,2], [2,3,undef]]);
cmp_deeply(e1([1,2], [4,2,0]), [[0,1,4], [1,2,2]]);

cmp_deeply(e2([1,2,3]), [[0,1], [1,2], [2,3]]);
cmp_deeply(e2([1,2,3], [4,2]), [[0,1,4], [1,2,2], [2,3,undef]]);
cmp_deeply(e2([1,2], [4,2,0]), [[0,1,4], [1,2,2]]);

done_testing();
