#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More;
use Test::Deep;

use Yandex::ListUtils qw/range/;

cmp_deeply(range(5,    20,     3    ), [5, 8, 11, 14, 17]);
cmp_deeply(range(8,    1,      -2   ), [8, 6, 4, 2]);
cmp_deeply(range(1,    5            ), [1, 2, 3, 4]);
cmp_deeply(range(1,    5,      undef), [1, 2, 3, 4]);
cmp_deeply(range(4,    undef,  undef), [0, 1, 2, 3]);
cmp_deeply(range(4                  ), [0, 1, 2, 3]);
cmp_deeply(range(+1,   +5,     +2   ), [1, 3]);
cmp_deeply(range(                   ), [],                  'should be an empty array');

like(ref range(3), qr/ARRAY/, 'should be a ref to array');

my @tests = (
    [5, 20, 3.5],
    [5, 19.9, 3],
    [5.1, 20, 3],
    ['a', 20, 3],
    [5, 'b', 3],
    [5, 20, 'c'],
    [5, 20, -3],
    [5, 4, 3],
    [20, 4, 0],
    [[0], 4, 1],
    [1, [4], 1],
    [2, 4, [1]],
    [2, undef, 1],
    [undef, undef, 1],
    [undef, undef, 1],
);
{   # Подавляем предупреждения 'Use of uninitialized value in pattern match'
    local $SIG{__WARN__} = sub { };
    map { cmp_deeply(range( ${$_}[0], ${$_}[1], ${$_}[2] ), [], 'should be an empty array'); } @tests;
}

done_testing();