#!/usr/bin/perl -w

use strict;
use Test::More;
use Test::Deep;
use List::MoreUtils qw/uniq/;

use Yandex::ListUtils;

*ws = \&Yandex::ListUtils::weighted_shuffle;

my @a = map {+{weight => $_, "x$_" => $_}} 1..20;

is(0, scalar(ws()));

is(scalar(@a), scalar(ws(@a)));

for (1..10) {
    # элементы не меняются после перестановок
    cmp_deeply([ws(@a)], bag(@a));
}

for (1..1000) {
    # если у кого-то вес 0 - он не выбирается
    is([ws({weight=>0},{weight=>1})]->[0]->{weight}, 1);
}

# если у всех вес 0 - они ввбыраются случайным образом
is(
    scalar(uniq map {[ws({weight=>0, d=>0}, {weight=>0, d => 1}, {weight=>0, d => 2})]->[0]->{d}} 1..10_000),
    3
    );

# если веса разные - все выбираются иногда
is(
    scalar(uniq map {[ws({weight=>1, d=>0}, {weight=>2, d => 1}, {weight=>3, d => 2})]->[0]->{d}} 1..10_000),
    3
    );

done_testing;
