#!/usr/bin/perl -w

use strict;
use Test::More tests => 14;
use Test::Deep;

use Yandex::ListUtils qw/xdiff xisect/;

my @a = (1,2,3,4,5,6,7);
my @b = (3,4,5,6,7,8,9,10);
my @a_with_reps = (1,2,3,4,5,6,7,3,4,1,2,1);
my @b_with_reps = (3,4,5,6,7,8,9,10,8,9,3,4,6,6,5,10,4);

my @a_text = qw /text1 text2 text3 text4 text5/;
my @b_text = qw /text3 text4 text5 text6 text7/;
my @a_text_with_reps = qw /text1 text2 text3 text4 text5 text1 text2 text2/;
my @b_text_with_reps = qw /text3 text4 text5 text6 text7 text7 text6 text6/;


cmp_deeply([sort {$a <=> $b} @{xdiff(\@a,\@b)}], [sort {$a <=> $b} (1,2,8,9,10)]);
cmp_deeply([sort {$a <=> $b} @{xdiff(\@a,\@b_with_reps)}], [sort {$a <=> $b} (1,2,8,9,10)]);
cmp_deeply([sort {$a <=> $b} @{xdiff(\@a_with_reps,\@b)}], [sort {$a <=> $b} (1,2,8,9,10)]);
cmp_deeply([sort {$a <=> $b} @{xdiff(\@a_with_reps,\@b_with_reps)}], [sort {$a <=> $b} (1,2,8,9,10)]);


cmp_deeply([sort {$a <=> $b} @{ xdiff( \@a, xisect(\@a,\@b) )}], [sort {$a <=> $b} (1,2)]);
cmp_deeply([sort {$a <=> $b} @{ xdiff( \@b, xisect(\@a,\@b) )}], [sort {$a <=> $b} (8,9,10)]);
cmp_deeply([sort {$a <=> $b} @{ xdiff( \@b_with_reps, xisect(\@a_with_reps,\@b_with_reps) )}], [sort {$a <=> $b} (8,9,10)]);


cmp_deeply([sort {$a cmp $b} @{xdiff(\@a_text,\@b_text)}], [sort {$a cmp $b} qw /text1 text2 text6 text7/]);
cmp_deeply([sort {$a cmp $b} @{xdiff(\@a_text,\@b_text_with_reps)}], [sort {$a cmp $b} qw /text1 text2 text6 text7/]);
cmp_deeply([sort {$a cmp $b} @{xdiff(\@a_text_with_reps,\@b_text)}], [sort {$a cmp $b} qw /text1 text2 text6 text7/]);
cmp_deeply([sort {$a cmp $b} @{xdiff(\@a_text_with_reps,\@b_text_with_reps)}], [sort {$a cmp $b} qw /text1 text2 text6 text7/]);


cmp_deeply([sort {$a cmp $b} @{ xdiff( \@a_text, xisect(\@a_text,\@b_text) )}], [sort {$a cmp $b} qw /text1 text2/]);
cmp_deeply([sort {$a cmp $b} @{ xdiff( \@b_text, xisect(\@a_text,\@b_text) )}], [sort {$a cmp $b} qw /text6 text7/]);
cmp_deeply([sort {$a cmp $b} @{ xdiff( \@b_text_with_reps, xisect(\@a_text_with_reps,\@b_text_with_reps) )}], [sort {$a cmp $b} qw /text6 text7/]);