#!/usr/bin/perl -w

use strict;
use Test::More;
use Test::Deep;

use Yandex::ListUtils qw/xflatten/;

cmp_deeply([xflatten()], []);
cmp_deeply([xflatten(1, 2, 3, 4, 5)], [1, 2, 3, 4, 5]);
cmp_deeply([xflatten(undef)], [undef]);
cmp_deeply([xflatten(undef, undef, 1, 2, 3, 4, 5)], [undef, undef, 1, 2, 3, 4, 5]);
cmp_deeply([xflatten(\1, [2, 3, 4, undef], undef, {})], [\1, 2, 3, 4, undef, undef, {}]);
cmp_deeply([xflatten(\1, [2, [3, 4], undef], undef, {})], [\1, 2, [3, 4], undef, undef, {}]);
cmp_deeply([xflatten(\1, [2, [3, 4, {a => 1}], {b => 1}], \[], {})], [\1, 2, [3, 4, {a => 1}], {b => 1}, \[], {}]);
cmp_deeply([xflatten([], [], [], [], [], [])], []);
cmp_deeply([xflatten([], [], [], ["a"], [], [])], ["a"]);
cmp_deeply([xflatten([], [], [], [], [], ["a"])], ["a"]);



done_testing;