#!/usr/bin/perl -w

use strict;
use Test::More tests => 5;
use Test::Deep;

use Yandex::ListUtils qw/xsort/;

use Carp ();
$SIG{__WARN__} = \&Carp::cluck;

my @a = ([2, "a"], [1, "b"], [11, "b"]);

cmp_deeply([xsort {()} @a], [@a]);

cmp_deeply([xsort {$_->[0]} @a], [sort {$a->[0] <=> $b->[0]} @a]);

cmp_deeply([xsort {\$_->[0]} @a], [sort {$b->[0] <=> $a->[0]} @a]);

cmp_deeply([xsort {\("$_->[0]")} @a], [sort {$b->[0] cmp $a->[0]} @a]);

cmp_deeply([xsort {($_->[1], \$_->[0])} @a], [sort {$a->[1] cmp $b->[1] || $b->[0] <=> $a->[0]} @a]);
