#!/usr/bin/perl -w

use strict;
use Test::More tests => 5;

use Yandex::ListUtils qw/xuniq/;

my @a;

@a = xuniq {$_} ();
is(scalar(@a), 0, "uniq of empty list should produce empty list");

@a= xuniq {$_} qw/1 2 3 4 3 2 1 4/;
is(scalar(@a), 4, "array with duplicates");

@a = xuniq {$_} qw/0 1 2 3 4 5 6 7 8 9/;
is(scalar(@a), 10, "array without duplicates");

@a = xuniq {$_} qw/0 00 000 00000/;
is(scalar(@a), 4, "elements compared as strings");

@a = xuniq {$_ + 0} qw/0 00 000 00000/;
is(scalar(@a), 1, "elements compared as numbers");

