#!/usr/bin/perl -w

use strict;
use Test::More tests => 15;

use Yandex::ScalarUtils qw/str/;

is(str(undef), "", "undef");
is(str(0.0), "0", "0.0 as number");
is(str("0.0"), "0.0", "0.0 as string");
is(str(""), "", "empty line");

is(str("Hello world"), "Hello world", "some string");

for $_ (1..10) {
    my @L = 0..9;
    my $s = join"", map {$L[rand $#L+1]} 0..10*$_;
    is(str($s), $s, "random sequence");
}

