#!/usr/bin/perl -w

# $Id$

use strict;

use Test::More;
use Test::Deep;
use Test::Exception;
use Yandex::DateTime;
use DateTime;

{
    local $SIG{__WARN__} = sub { };
    dies_ok { date(undef) };
}
dies_ok { date('abcde')      };
dies_ok { date('0000000')    };
dies_ok { date('00000000')   };
dies_ok { date('2012-03-00') };
dies_ok { date('2012-00-23') };
# bionic: поведение поменялось
=for none
Поменялось поведение DateTime::Format::MySQL
Проверочный однострочник:
perl -MData::Dumper -MDateTime::Format::MySQL -le 'print Dumper(DateTime::Format::MySQL->parse_date("2012/03/23"));'
На trusty (perl v5.18.2, libdatetime-format-mysql-perl=0.04-3) падает:
Invalid date format: 2012/03/23 at -e line 1.
На bionic (perl v5.26.1, libdatetime-format-mysql-perl=0.06-1) выводит какой-то осмысленный объект
=cut
#dies_ok { date('2012/03/23') };

dies_ok { date('2012-0323')  };
dies_ok { date('201203-23')  };
dies_ok { date('20120230')   };
dies_ok { date(\'20120323')  } 'refs not allowed';

my $dt = DateTime->new(
    year  => 2012,
    month => 3,
    day   => 12
);

cmp_deeply(date('20120312'),           $dt);
cmp_deeply(date('2012-03-12'),         $dt);
cmp_deeply(date('2012-03-12', 'blah'), $dt);

done_testing();
