#!/usr/bin/perl -w

# $Id$

use strict;

use Test::More;
use Test::Deep;
use Test::Exception;
use Yandex::DateTime;
use DateTime;

{
    local $SIG{__WARN__} = sub { };
    dies_ok { datetime(undef) };
}
dies_ok { datetime('abcde')               };
dies_ok { datetime('00000000')            };
dies_ok { datetime('00000000000000')      };
dies_ok { datetime('0000-00-00 00-00-00') };
dies_ok { datetime('2012-03-12_13-41-10') };
dies_ok { datetime('2012-03-12-13-41-10') };
dies_ok { datetime('2012-02-30 13-41-00') };
dies_ok { datetime('20121232134101')      };
dies_ok { datetime(\'20121231235959')     } 'refs not allowed';
# bionic: поведение поменялось
# аналогично t/DateTime/date.t:22. Проверочный однострочник:
# perl -MData::Dumper -MDateTime::Format::MySQL -le 'print Dumper(DateTime::Format::MySQL->parse_datetime("2013-12-31 23-59-59"));'
#dies_ok { datetime('2013-12-31 23-59-59') } 'bad time delimiter';
# perl -MData::Dumper -MDateTime::Format::MySQL -le 'print Dumper(DateTime::Format::MySQL->parse_datetime("2013/12/31 23:59:59"));'
#dies_ok { datetime('2013/12/31 23:59:59') } 'bad date delimiter';

my $dt = DateTime->new(
    year   => 2013,
    month  => 12,
    day    => 31,
    hour   => 23,
    minute => 59,
    second => 59,
);

cmp_deeply(datetime('20131231235959'),               $dt);
cmp_deeply(datetime('2013-12-31 23:59:59'),          $dt);

done_testing();
