#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More tests => 20;
use Test::Exception;

use Yandex::DateTime;
use DateTime::Duration;

sub c {
    return DateTime::Duration->compare(duration(@{$_[0]}), duration(@{$_[1]}))
}

sub d {
    return duration(@_);
}

ok(!c(["1d"], [days => 1]));
is(c(["1d"], ["2d"]), -1);
ok(!c(["1d-2d"], [days => -1]));
ok(!c(["1m"], [months => 1]));
ok(!c(["1m2d4y"], [months => 1, days => 2, years => 4]));
ok(!c(["1y"], [years => 1]));

ok(c(["1y"], [days => 1]));
ok(c(["1m"], [days => 1]));

ok(c(["1m"], ["1M"]));  # months and minutes
ok(!c(["1M"], [minutes => 1]));
ok(!c(["1H"], [hours => 1]));
ok(!c(["1S"], [seconds => 1]));

ok(!c(["1min"], [minutes => 1]));
ok(!c(["1hour"], [hours => 1]));
ok(!c(["1sec"], [seconds => 1]));

ok(!c(["1hour-1min+5S"], [hours => 1, minutes => -1, seconds => 5]));

dies_ok {d("1Y")} "1Y forbidden; 1y is right"; # case sensetive;
dies_ok {d("1D")} "1D forbidden; 1d is right"; # case sensetive;
dies_ok {d("1h")} "1h forbidden; 1H is right"; # case sensetive;
dies_ok {d("1s")} "1s forbidden; 1S is right"; # case sensetive;

