#!/usr/bin/perl -w

# $Id$

use strict;

use Test::More;
use Test::Deep;
use Test::Exception;
use Test::MockTime qw/:all/;
use Yandex::DateTime;
use DateTime;

{
    local $SIG{__WARN__} = sub { };
    dies_ok { iso8601_2_datetime(undef               ) };
}
dies_ok { iso8601_2_datetime(\'2013-03-01'       ) };
dies_ok { iso8601_2_datetime(['2013-03-01']      ) };
dies_ok { iso8601_2_datetime({this=>'2013-03-01'}) };
dies_ok { iso8601_2_datetime('now'               ) };
dies_ok { iso8601_2_datetime('20130312T14:44:10' ) };
dies_ok { iso8601_2_datetime('2013-03-12T144410' ) };

my $dt = DateTime->new(
    year      => 2013,
    month     => 3,
    day       => 1,
    hour      => 0,
    minute    => 0,
    second    => 0,
    time_zone => $Yandex::DateTime::YANDEX_LOCAL_TIMEZONE
);

is($Yandex::DateTime::YANDEX_LOCAL_TIMEZONE, 'Europe/Moscow', 'default time zone is Europe/Moscow');

cmp_deeply(iso8601_2_datetime('2013-03'), $dt);
cmp_deeply(iso8601_2_datetime('-13-03'),  $dt);

$dt->set_day(12);
cmp_deeply(iso8601_2_datetime('20130312'),   $dt);
cmp_deeply(iso8601_2_datetime('2013-03-12'), $dt);

$dt->set_hour(14);
$dt->set_minute(44);
$dt->set_second(10);
cmp_deeply(iso8601_2_datetime('2013-03-12T14:44:10'),       $dt);
cmp_deeply(iso8601_2_datetime('20130312T144410'),           $dt);
cmp_deeply(iso8601_2_datetime('2013-03-12T10:44:10+00'),    $dt);
cmp_deeply(iso8601_2_datetime('2013-03-12T10:44:10Z'),      $dt);
cmp_deeply(iso8601_2_datetime('2013-03-12T13:14:10+02:30'), $dt);

set_fixed_time('12/03/2013', '%d/%m/%Y');
cmp_deeply(iso8601_2_datetime('14:44:10'),                  $dt);
$dt->set_second(0);
cmp_deeply(iso8601_2_datetime('T1444'),                     $dt);

done_testing();