#!/usr/bin/perl -w

# $Id$

use strict;

use Test::More;
use Test::Exception;
use Test::MockTime qw/:all/;
use Yandex::DateTime;
use DateTime;

{
    local $SIG{__WARN__} = sub { };
    dies_ok { iso8601_2_mysql(undef) };
}
dies_ok { iso8601_2_mysql(\'2013-03-01'       ) };
dies_ok { iso8601_2_mysql(['2013-03-01']      ) };
dies_ok { iso8601_2_mysql({this=>'2013-03-01'}) };
dies_ok { iso8601_2_mysql('now'               ) };
dies_ok { iso8601_2_mysql('20130312T14:44:10' ) };
dies_ok { iso8601_2_mysql('2013-03-12T144410' ) };

is(iso8601_2_mysql('20130312'),                  '2013-03-12 00:00:00');
is(iso8601_2_mysql('2013-03-12'),                '2013-03-12 00:00:00');
is(iso8601_2_mysql('2013-03-12T14:44:10'),       '2013-03-12 14:44:10');
is(iso8601_2_mysql('20130312T144410'),           '2013-03-12 14:44:10');
is(iso8601_2_mysql('2013-03'),                   '2013-03-01 00:00:00');
is(iso8601_2_mysql('-12-11'),                    '2012-11-01 00:00:00');
is(iso8601_2_mysql('2013-03-12T14:44:10+00'),    '2013-03-12 18:44:10', 'default YANDEX_LOCAL_TIMEZONE is Europe/Moscow');
is(iso8601_2_mysql('2013-03-12T14:44:10+02:30'), '2013-03-12 16:14:10', 'default YANDEX_LOCAL_TIMEZONE is Europe/Moscow');
is(iso8601_2_mysql('2013-03-12T14:44:10Z'),      '2013-03-12 18:44:10', 'default YANDEX_LOCAL_TIMEZONE is Europe/Moscow');

set_fixed_time('06/06/2013 06:00:00', '%m/%d/%Y %H:%M:%S');
is(iso8601_2_mysql('15:20:21'),                  '2013-06-06 15:20:21');
is(iso8601_2_mysql('T1009'),                      '2013-06-06 10:09:00');
is(iso8601_2_mysql('T1617'),                      '2013-06-06 16:17:00');
isnt(iso8601_2_mysql('1009'),                     '2013-06-06 10:09:00');
isnt(iso8601_2_mysql('1617'),                     '2013-06-06 16:17:00');

done_testing();