#!/usr/bin/perl -w

# $Id$

use strict;

use Test::More;
use Test::Exception;
use Yandex::DateTime;

dies_ok { mysql2iso8601('2013-03-12 14:44:10',  'fake_time_zone') };
dies_ok { mysql2iso8601(\'2013-03-12 14:44:10', 'fake_time_zone') };
dies_ok { mysql2iso8601('2013-03-12 14:44:10',  \'fake_time_zone') };
dies_ok { mysql2iso8601('2013-03-12-14:44:10',  'local') };
dies_ok { mysql2iso8601('20130312 144410',      'UTC') };
dies_ok { mysql2iso8601('2013-02-30 14:44:10',  'local') };
dies_ok { mysql2iso8601('2013-03-12 14:60:10',  'local') };
{
    local $SIG{__WARN__} = sub { };
    dies_ok { mysql2iso8601('2013-03-12 14:44:10',  undef) };
    dies_ok { mysql2iso8601(undef,                  'UTC') };
}

is(mysql2iso8601('2013-06-12 14:44:10', 'local'),        '2013-06-12T10:44:10Z');
is(mysql2iso8601('2013-06-12 14:44:10', 'UTC'),          '2013-06-12T14:44:10Z');
is(mysql2iso8601('2013-06-12 14:44:10', 'Europe/Paris'), '2013-06-12T12:44:10Z');
is(mysql2iso8601('2013-01-12 14:44:10', 'Europe/Paris'), '2013-01-12T13:44:10Z');

done_testing();