#!/usr/bin/perl -w

# $Id$

use strict;

use Test::More;
use Test::Deep;
use Test::MockTime qw/:all/;
use Yandex::DateTime;
use DateTime;

set_fixed_time(CORE::time());

my $localTZ = DateTime::TimeZone->new(name => 'local');

cmp_deeply(now(),     DateTime->now(time_zone => $localTZ));
cmp_deeply(now_utc(), DateTime->now());

set_fixed_time('2013-03-13T00:00:00Z');
my $dt = DateTime->new(
    year       => 2013,
    month      => 3,
    day        => 13,
    hour       => 4,    # now() возвращает время в локальной зоне, для москвы это +4
    minute     => 0,
    second     => 0,
    time_zone =>'local',
);
cmp_deeply(now(), $dt);
is(now(), $dt);

my $dt_utc = DateTime->new(
    year      => 2013,
    month     => 3,
    day       => 13,
    hour      => 0,
    minute    => 0,
    second    => 0,
    time_zone =>'UTC',
);
cmp_deeply(now_utc(), $dt_utc);
is(now_utc(), $dt_utc);

done_testing();