#!/usr/bin/perl -w

# $Id$

use strict;

use Test::More;
use Test::Exception;
use Test::MockTime qw/:all/;
use Yandex::DateTime;
use DateTime;

{
    local $SIG{__WARN__} = sub { };
    dies_ok { tz_offset(undef) };
}
dies_ok { tz_offset(1) };
dies_ok { tz_offset('fake_time_zone') };
dies_ok { tz_offset(\'local') };

is(tz_offset('UTC'), 0);
is(tz_offset('GMT'), 0);

set_fixed_time('06/06/2013 06:00:00', '%m/%d/%Y %H:%M:%S');
is(tz_offset('Europe/Moscow'), 14400);
is(tz_offset('Europe/Paris'), 7200);
set_fixed_time('01/01/2013 06:00:00', '%m/%d/%Y %H:%M:%S');
is(tz_offset('Europe/Moscow'), 14400);
is(tz_offset('Europe/Paris'), 3600);

done_testing();
