#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;

use Yandex::TimeCommon;

is(check_mysql_date(undef),                 0);
is(check_mysql_date(''),                    0);
is(check_mysql_date('asdfewrq'),            0);
is(check_mysql_date('0000-00-00 00:00:00'), 0);

# странное поведение, стоит изменить? (унаследовано от mysql2unix)
is(check_mysql_date('0'), 1);

my @tests = (
    '1970-01-01 03:00:00',
    '1970-01-01 04:01:01',
    '20121212120212',
    '20000112232156',
    '19801024081234',
);

foreach my $test (@tests) {
    is(check_mysql_date($test), 1);
}

done_testing();
