#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Deep;
use Test::Exception;

use Yandex::TimeCommon;

my @tests = (
    [["20131501", "20130123"] => undef],
    [["20130101", "201301233"] => undef],
    [["20131001"] => undef],
    [[undef, "20131001"] => undef],
 
    [["20130201", "20130123"] => []],
    [["20130101", "20110123"] => []],
    [["20130123", "20130122"] => []],

    [["20130122", "20130122"] => [201301]],
    [["20130101", "20130123"] => [201301]],
    [["20120901", "20130123"] => [201209, 201210, 201211, 201212, 201301]],

    [["2013-10-01", "2013-10-31"] => [201310]],
    [["20131001", "2013-10-31"] => [201310]],
    [["2013-10-01", "20131031"] => [201310]],
    [["2013-10-28", "2013-11-02"] => [201310, 201311]],
    );

for my $t (@tests) {
    if (!defined $t->[1]) {
        dies_ok {get_distinct_months(@{$t->[0]})};
    } else {
        cmp_deeply([get_distinct_months(@{$t->[0]})], $t->[1]);
    }
}

done_testing();
