#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Yandex::TimeCommon;

dies_ok { gm_to_local(undef) };
dies_ok { gm_to_local('') };
dies_ok { gm_to_local('asdfewrq') };
dies_ok { gm_to_local('0000-00-00 00:00:00') };

is(gm_to_local('20130101000000'),      20130101040000);
is(gm_to_local('2011-01-01 00:00:00'), 20110101030000);
is(gm_to_local('2020-01-01 17:43:10'), 20200101204310);

# странное поведение, стоит изменить? (унаследовано от mysql2unix)
is(gm_to_local('0'), 19700101060000);

done_testing();
