#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;
use POSIX qw(tzset);
use Test::MockTime qw/:all/;

use Yandex::TimeCommon;

# Устанавливаем timezone UTC
$ENV{TZ} = 'UTC0';
tzset;

my $time1 = 1363181614; # Wed Mar 13 13:33:34 2013
my $time2 =  876543210; # Sat Oct 11 04:13:30 1997
my $time3 = 1234567890; # Fri Feb 13 23:31:30 2009

is(human_date($time1), '13.03.2013');
is(human_date($time2), '11.10.1997');
is(human_date($time3), '13.02.2009');

set_fixed_time($time3);
is(human_date(),       '13.02.2009');   # при вызове без параметров возвращает сегодняшнюю дату
restore_time();

SKIP: { # Не реализована проверка принимаемого $time. Хотелось бы, чтобы функция умирала, а не отдавала какой-то результат, кидая при этом warning
    my @args = (
        \1234,
        {},
        [],
        'abc',
        '0x010',
    );

    skip 'Argument checking is not yet implemented', scalar @args if 1;

    foreach my $arg (@args) {
        dies_ok { human_date($arg); } 'Argument must be a valid time';
    }
}

done_testing();
