#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;
use POSIX qw(tzset);
use Test::MockTime qw/:all/;

use Yandex::TimeCommon;

# Устанавливаем timezone UTC
$ENV{TZ} = 'UTC0';
tzset;

my $time1 = 1363181614; # Wed Mar 13 13:33:34 2013
my $time2 =  876543210; # Sat Oct 11 04:13:30 1997
my $time3 = 1234567890; # Fri Feb 13 23:31:30 2009

is(human_datetime($time1), '2013-03-13 13:33:34');
is(human_datetime($time2), '1997-10-11 04:13:30');
is(human_datetime($time3), '2009-02-13 23:31:30');

set_fixed_time($time3);
is(human_datetime(),       '2009-02-13 23:31:30');  # при вызове без параметров, возвращает datetime от "сейчас"
restore_time();

SKIP: { # Не реализована проверка принимаемого $time. Хотелось бы, чтобы функция умирала, а не отдавала какой-то результат, кидая при этом warning
    my @args = (
        \1234,
        {},
        [],
        'abc',
        '0x010',
    );

    skip 'Argument checking is not yet implemented', scalar @args if 1;

    foreach my $arg (@args) {
        dies_ok { human_datetime($arg); } 'Argument must be a valid time';
    }
}

done_testing();
